<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\GoogleController;
use App\Http\Controllers\AfrikotController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('awal');
})->name('awal');

Route::get('/preApps', function () {
    return view('preApps');
})->name('preApps');

Route::get('/pendahuluan', function () {
    return view('pendahuluan');
})->name('pendahuluan');

Route::get('/navigasiUtama', [App\Http\Controllers\AfrikotController::class, 'navigasiUtama'])->name('navigasiUtama');

Route::get('/dataDiri', [App\Http\Controllers\AfrikotController::class, 'dataDiri'])->name('dataDiri');

Route::get('/riwayatKesehatan', [App\Http\Controllers\AfrikotController::class, 'riwayatKesehatan'])->name('riwayatKesehatan');

Route::get('/riwayatKehamilan', [App\Http\Controllers\AfrikotController::class, 'riwayatKehamilan'])->name('riwayatKehamilan');

Route::get('/kehamilanSekarang', [App\Http\Controllers\AfrikotController::class, 'kehamilanSekarang'])->name('kehamilanSekarang');

Route::get('/listSurvey', [App\Http\Controllers\AfrikotController::class, 'listSurvey'])->name('listSurvey');

Route::get('/interpretasi', [App\Http\Controllers\AfrikotController::class, 'interpretasi'])->name('interpretasi');

Route::post('/dataDiriIstri/store', [App\Http\Controllers\AfrikotController::class, 'store'])->name('dataDiriIstriStore');

Route::post('/dataDiriSuami/store', [App\Http\Controllers\AfrikotController::class, 'suamiStore'])->name('dataDiriSuamiStore');

Route::post('/kesehatanStore/store', [App\Http\Controllers\AfrikotController::class, 'kesehatanStore'])->name('kesehatanStore');

Route::post('/kehamilanStore/store', [App\Http\Controllers\AfrikotController::class, 'kehamilanStore'])->name('kehamilanStore');

Route::post('/kehamilanSekarangStore/store', [App\Http\Controllers\AfrikotController::class, 'kehamilanSekarangStore'])->name('kehamilanSekarangStore');

Route::post('/nutrisiStore/store', [App\Http\Controllers\AfrikotController::class, 'nutrisiStore'])->name('nutrisiStore');

Route::post('/bukuKiaStore/store', [App\Http\Controllers\AfrikotController::class, 'bukuKiaStore'])->name('bukuKiaStore');

Route::post('/anemiaKehamilanStore/store', [App\Http\Controllers\AfrikotController::class, 'anemiaKehamilanStore'])->name('anemiaKehamilanStore');

Route::post('/userNavigasi/store', [App\Http\Controllers\AfrikotController::class, 'userNavigasi'])->name('userNavigasi');

Route::get('auth/google', [App\Http\Controllers\GoogleController::class, 'redirectToGoogle']);

Route::get('auth/google/callback', [App\Http\Controllers\GoogleController::class, 'handleGoogleCallback']);

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('/profile', [App\Http\Controllers\ProfileController::class, 'index'])->name('profile');

Route::put('/profile', 'ProfileController@update')->name('profile.update');

Route::get('/about', function () {
    return view('about');
})->name('about');

Route::get('/blank', function () {
    return view('blank');
})->name('blank');

Route::middleware('auth')->group(function() {
    Route::resource('basic', BasicController::class);
});

Route::middleware('auth')->group(function() {
    Route::resource('imt', ImtController::class);
});

Route::middleware('auth')->group(function() {
    Route::resource('lingkarLengan', LingkarLenganController::class);
});

